<?php
header("Content-Type: application/json");

// Database connection
$conn = new mysqli("localhost", "root", "", "quickcrusine");

// Read input
$data = json_decode(file_get_contents("php://input"), true);

// Validate input
if (!isset($data['order_id']) || !isset($data['status'])) {
    echo json_encode(['success' => false, 'message' => 'Missing order ID or status']);
    exit;
}

$orderId = intval($data['order_id']);
$status = $data['status'];

// Allowed statuses
$allowedStatuses = ['pending', 'completed', 'cancelled']; // you can add more

if (!in_array($status, $allowedStatuses)) {
    echo json_encode(['success' => false, 'message' => 'Invalid status']);
    exit;
}

// Update order status
$query = "UPDATE orders SET status = ? WHERE id = ?";
$stmt = $conn->prepare($query);

if ($stmt) {
    $stmt->bind_param("si", $status, $orderId);
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Order status updated']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update order status']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}

$conn->close();
?>
