<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed."]);
    exit;
}

$input = json_decode(file_get_contents("php://input"), true);

$id = $input['id'] ?? 0;
$name = $input['name'] ?? '';
$price = $input['price'] ?? '';
$image = $input['image'] ?? '';

if (!$id || !$name || !$price) {
    echo json_encode(["success" => false, "message" => "All fields are required."]);
    exit;
}

$stmt = $conn->prepare("UPDATE menu SET name = ?, price = ?, image = ? WHERE id = ?");
$stmt->bind_param("sdsi", $name, $price, $image, $id);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Menu item updated successfully."]);
} else {
    echo json_encode(["success" => false, "message" => "Update failed."]);
}

$stmt->close();
$conn->close();
?>
