<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

error_reporting(E_ALL);
ini_set('display_errors', 1);

$data = json_decode(file_get_contents("php://input"), true);

// Required parameter
$userId = $data['userId'] ?? null;

// Optional filters
$status = $data['status'] ?? null;
$dateFrom = $data['dateFrom'] ?? null;
$dateTo = $data['dateTo'] ?? null;
$restaurantId = $data['restaurantId'] ?? null;

if (!$userId) {
    echo json_encode(["success" => false, "message" => "Missing user ID."]);
    exit;
}

$conn = new mysqli("localhost", "root", "", "quickcrusine");

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed."]);
    exit;
}

// Base query with JOIN to get restaurant name
$query = "SELECT orders.*, restaurants.name AS restaurantName 
          FROM orders 
          LEFT JOIN restaurants ON orders.restaurant_id = restaurants.id
          WHERE orders.user_id = ?";
$params = [$userId];
$types = "i";

// Apply dynamic filters
if ($status) {
    $query .= " AND orders.status = ?";
    $params[] = $status;
    $types .= "s";
}
if ($restaurantId) {
    $query .= " AND orders.restaurant_id = ?";
    $params[] = $restaurantId;
    $types .= "i";
}
if ($dateFrom) {
    $query .= " AND orders.created_at >= ?";
    $params[] = $dateFrom . " 00:00:00";
    $types .= "s";
}
if ($dateTo) {
    $query .= " AND orders.created_at <= ?";
    $params[] = $dateTo . " 23:59:59";
    $types .= "s";
}

$query .= " ORDER BY orders.created_at DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();

$orders = [];

while ($order = $result->fetch_assoc()) {
    $orderId = $order['id'];

    // Fetch items for each order
    $itemStmt = $conn->prepare("SELECT name, quantity, price FROM order_items WHERE order_id = ?");
    $itemStmt->bind_param("i", $orderId);
    $itemStmt->execute();
    $itemResult = $itemStmt->get_result();

    $items = [];
    while ($item = $itemResult->fetch_assoc()) {
        $items[] = $item;
    }

    $order['items'] = $items;
    $orders[] = $order;
}

echo json_encode(["success" => true, "orders" => $orders]);

$conn->close();
?>
