<?php
// restaurant-dashboard.php
session_start();

// Example: Check if user is logged in (you can customize this)

// Example database connection
$mysqli = new mysqli("localhost", "root", "", "quickcrusine");

if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Fetch total orders today
$result = $mysqli->query("SELECT COUNT(*) AS total_orders FROM orders WHERE DATE(order_date) = CURDATE()");
$totalOrders = $result->fetch_assoc()['total_orders'];

// Fetch pending orders count
$result = $mysqli->query("SELECT COUNT(*) AS pending_orders FROM orders WHERE status = 'pending'");
$pendingOrders = $result->fetch_assoc()['pending_orders'];

// Fetch recent orders (last 5)
$recentOrdersResult = $mysqli->query("SELECT order_id, customer_name, status, order_date FROM orders ORDER BY order_date DESC LIMIT 5");

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Restaurant Dashboard</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f4; margin: 0; padding: 20px; }
        h1 { color: #333; }
        .stats { display: flex; gap: 20px; margin-bottom: 20px; }
        .stat { background: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 0 5px rgba(0,0,0,0.1); flex: 1; text-align: center; }
        table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 5px; overflow: hidden; box-shadow: 0 0 5px rgba(0,0,0,0.1); }
        th, td { padding: 12px 15px; border-bottom: 1px solid #ddd; }
        th { background: #eee; }
        tr:hover { background: #f1f1f1; }
    </style>
</head>
<body>
    <h1>Welcome to Your Restaurant Dashboard</h1>

    <div class="stats">
        <div class="stat">
            <h2><?php echo $totalOrders; ?></h2>
            <p>Total Orders Today</p>
        </div>
        <div class="stat">
            <h2><?php echo $pendingOrders; ?></h2>
            <p>Pending Orders</p>
        </div>
    </div>

    <h2>Recent Orders</h2>
    <table>
        <thead>
            <tr>
                <th>Order ID</th>
                <th>Customer</th>
                <th>Status</th>
                <th>Order Date</th>
            </tr>
        </thead>
        <tbody>
            <?php while($order = $recentOrdersResult->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($order['order_id']); ?></td>
                    <td><?php echo htmlspecialchars($order['customer_name']); ?></td>
                    <td><?php echo htmlspecialchars(ucfirst($order['status'])); ?></td>
                    <td><?php echo htmlspecialchars($order['order_date']); ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</body>
</html>

<?php
$mysqli->close();
?>
