<?php
header('Content-Type: application/json');
$conn = new mysqli("localhost", "root", "", "quickcrusine");

$data = json_decode(file_get_contents("php://input"), true);
$user_id = $data['user_id'];
$total = $data['total_amount'];
$items = $data['items'];

$conn->begin_transaction();

try {
  $stmt = $conn->prepare("INSERT INTO orders (user_id, total_amount) VALUES (?, ?)");
  $stmt->bind_param("id", $user_id, $total);
  $stmt->execute();
  $order_id = $stmt->insert_id;

  $stmt_item = $conn->prepare("INSERT INTO order_items (order_id, menu_id, quantity) VALUES (?, ?, ?)");

  foreach ($items as $item) {
    $stmt_item->bind_param("iii", $order_id, $item['menu_id'], $item['quantity']);
    $stmt_item->execute();
  }

  $conn->commit();

  echo json_encode(["success" => true, "order_id" => $order_id]);
} catch (Exception $e) {
  $conn->rollback();
  echo json_encode(["success" => false, "error" => $e->getMessage()]);
}
?>
