<?php
header('Content-Type: application/json');

// === CONFIG ===
$isLive = false;

$baseUrl = $isLive
  ? "https://proxy.momoapi.mtn.com"
  : "https://sandbox.momodeveloper.mtn.com";

$subscriptionKey = $isLive
  ? "YOUR_LIVE_SUBSCRIPTION_KEY"
  : "YOUR_SANDBOX_SUBSCRIPTION_KEY";

$apiUser = $isLive
  ? "YOUR_LIVE_API_USER"
  : "YOUR_SANDBOX_API_USER";

$apiKey = $isLive
  ? "YOUR_LIVE_API_KEY"
  : "YOUR_SANDBOX_API_KEY";

$targetEnvironment = $isLive ? "mtnswz" : "sandbox";
$currency = $isLive ? "SZL" : "EUR";

// === INPUT ===
$data = json_decode(file_get_contents("php://input"), true);
$amount = $data['amount'];
$partyId = $data['partyId'];

// === GET ACCESS TOKEN ===
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "$baseUrl/collection/token/");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "Authorization: Basic " . base64_encode("$apiUser:$apiKey")
]);
$tokenRes = curl_exec($ch);
curl_close($ch);

$tokenData = json_decode($tokenRes, true);
$accessToken = $tokenData['access_token'] ?? null;

if (!$accessToken) {
  echo json_encode(["success" => false, "error" => "Failed to get access token"]);
  exit;
}

// === MAKE PAYMENT REQUEST ===
$refId = uniqid("momo_", true);
$payload = [
  "amount" => $amount,
  "currency" => $currency,
  "externalId" => "ORDER-" . time(),
  "payer" => [
    "partyIdType" => "MSISDN",
    "partyId" => $partyId
  ],
  "payerMessage" => "QuickCrusine Order",
  "payeeNote" => "QuickCrusine"
];

$ch = curl_init("$baseUrl/collection/v1_0/requesttopay");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "X-Reference-Id: $refId",
  "X-Target-Environment: $targetEnvironment",
  "Ocp-Apim-Subscription-Key: $subscriptionKey",
  "Authorization: Bearer $accessToken",
  "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
$requestRes = curl_exec($ch);
curl_close($ch);

// === CHECK PAYMENT STATUS ===
sleep(2); // wait briefly before checking

$ch = curl_init("$baseUrl/collection/v1_0/requesttopay/$refId");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "X-Target-Environment: $targetEnvironment",
  "Ocp-Apim-Subscription-Key: $subscriptionKey",
  "Authorization: Bearer $accessToken"
]);
$statusRes = curl_exec($ch);
curl_close($ch);

$statusData = json_decode($statusRes, true);

echo json_encode([
  "success" => true,
  "referenceId" => $refId,
  "status" => $statusData
]);
