<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit;
}

$input = json_decode(file_get_contents("php://input"), true);
$restaurant_id = $input['restaurant_id'] ?? 0;

if (!$restaurant_id) {
    echo json_encode(["success" => false, "message" => "Missing restaurant ID"]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM orders WHERE restaurant_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $restaurant_id);
$stmt->execute();

$result = $stmt->get_result();
$orders = [];

while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}

echo json_encode(["success" => true, "orders" => $orders]);

$stmt->close();
$conn->close();
?>
