<?php
header("Content-Type: application/json");

// Database connection
$conn = new mysqli("localhost", "root", "", "quickcrusine");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

// Get and validate inputs
$name = $_POST['name'] ?? '';
$price = $_POST['price'] ?? '';
$restaurant_id = $_POST['restaurant_id'] ?? '';
$image = $_FILES['image'] ?? null;

if (!$name || !$price || !$restaurant_id || !$image) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields or image']);
    exit;
}

// Ensure price is a valid number
if (!is_numeric($price)) {
    echo json_encode(['success' => false, 'message' => 'Invalid price value']);
    exit;
}

// Create uploads directory if it doesn't exist
$targetDir = "uploads/";
if (!file_exists($targetDir)) {
    mkdir($targetDir, 0777, true);
}

// Generate unique filename and move image
$ext = pathinfo($image["name"], PATHINFO_EXTENSION);
$filename = uniqid('menu_', true) . "." . strtolower($ext);
$targetFile = $targetDir . $filename;

if (!move_uploaded_file($image["tmp_name"], $targetFile)) {
    echo json_encode(['success' => false, 'message' => 'Failed to save image']);
    exit;
}

// Insert into database
$stmt = $conn->prepare("INSERT INTO menu (restaurant_id, name, price, image) VALUES (?, ?, ?, ?)");
$stmt->bind_param("isds", $restaurant_id, $name, $price, $targetFile);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Menu item added']);
} else {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}

$stmt->close();
$conn->close();
