<?php
header('Content-Type: application/json');

// === CONFIG ===
$isLive = false;

$baseUrl = $isLive 
  ? "https://proxy.momoapi.mtn.com"
  : "https://sandbox.momodeveloper.mtn.com";

$subscriptionKey = $isLive 
  ? "YOUR_LIVE_SUBSCRIPTION_KEY"
  : "YOUR_SANDBOX_SUBSCRIPTION_KEY";

$apiUser = $isLive 
  ? "YOUR_LIVE_API_USER_ID"
  : "YOUR_SANDBOX_API_USER_ID";

$apiKey = $isLive 
  ? "YOUR_LIVE_API_KEY"
  : "YOUR_SANDBOX_API_KEY";

$targetEnvironment = $isLive ? "mtnswz" : "sandbox"; // live env code may vary
$currency = $isLive ? "SZL" : "EUR"; // sandbox accepts EUR

// === INPUT DATA (ideally from your frontend / cart) ===
$amount = $_POST['amount'] ?? "10"; // Example
$partyId = $_POST['partyId'] ?? "46733123453"; // Sandbox test MSISDN

// === 1️⃣ Get access token ===
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "$baseUrl/collection/token/");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "Authorization: Basic " . base64_encode("$apiUser:$apiKey")
]);
$tokenResponse = curl_exec($ch);
if(curl_errno($ch)) {
  echo json_encode(["success" => false, "error" => curl_error($ch)]);
  exit;
}
curl_close($ch);

$tokenData = json_decode($tokenResponse, true);
$accessToken = $tokenData['access_token'] ?? null;

if (!$accessToken) {
  echo json_encode(["success" => false, "error" => "Failed to get access token"]);
  exit;
}

// === 2️⃣ Request payment ===
$referenceId = uniqid();
$paymentData = [
  "amount" => $amount,
  "currency" => $currency,
  "externalId" => "ORDER-" . time(),
  "payer" => [
    "partyIdType" => "MSISDN",
    "partyId" => $partyId
  ],
  "payerMessage" => "QuickCrusine Order",
  "payeeNote" => "Thanks!"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "$baseUrl/collection/v1_0/requesttopay");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "X-Reference-Id: $referenceId",
  "X-Target-Environment: $targetEnvironment",
  "Ocp-Apim-Subscription-Key: $subscriptionKey",
  "Authorization: Bearer $accessToken",
  "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
$requestResponse = curl_exec($ch);
if(curl_errno($ch)) {
  echo json_encode(["success" => false, "error" => curl_error($ch)]);
  exit;
}
curl_close($ch);

// === 3️⃣ Check status ===
sleep(2); // short delay to let MoMo process
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "$baseUrl/collection/v1_0/requesttopay/$referenceId");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  "X-Target-Environment: $targetEnvironment",
  "Ocp-Apim-Subscription-Key: $subscriptionKey",
  "Authorization: Bearer $accessToken"
]);
$statusResponse = curl_exec($ch);
if(curl_errno($ch)) {
  echo json_encode(["success" => false, "error" => curl_error($ch)]);
  exit;
}
curl_close($ch);

$statusData = json_decode($statusResponse, true);

echo json_encode([
  "success" => true,
  "referenceId" => $referenceId,
  "status" => $statusData
]);
